/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.impl2.AnimationManager;
import filenet.sim.animationdp.impl2.IVWSIMEventReader;
import filenet.sim.animationdp.impl2.VWSIMFileEventBuffer;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class VWSIMFileEventReader
implements IVWSIMEventReader {
    private VWSIMFileEventBuffer m_buffer = null;
    private long m_nCurrentElement = 0L;
    private RandomAccessFile m_fContents = null;
    private RandomAccessFile m_fIndex = null;
    private RandomAccessFile m_fTime = null;
    protected static Logger logger = Logger.getLogger("filenet.sim.animationdp.retrieval");
    private String m_className = "VWSIMFileEventReader";
    private String m_scenarioId = null;

    public VWSIMFileEventReader(VWSIMFileEventBuffer buf) {
        this.m_buffer = buf;
        if (buf != null) {
            this.m_scenarioId = this.m_buffer.getScenarioId();
            this.m_className = this.m_className + ";";
            this.m_className = this.m_className + this.m_scenarioId;
        }
    }

    public AnimationManager getPrevious() throws VWException {
        if (this.m_nCurrentElement == 0L) {
            return null;
        }
        if (this.m_nCurrentElement > 0L) {
            --this.m_nCurrentElement;
        }
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimationManager get() throws VWException {
        String m_method = "getNext";
        if (this.m_nCurrentElement == 0L) {
            logger.info(this.m_className, "getNext", "Starting..");
        }
        try {
            if (!this.hasNext()) {
                if (this.m_buffer.finished()) {
                    AnimationManager mgr = new AnimationManager(this.m_buffer.finished(), this.m_buffer.getStatus(), this.m_buffer.getStatusMessage());
                    return mgr;
                }
                VWSIMFileEventBuffer mgr = this.m_buffer;
                synchronized (mgr) {
                    if (logger.isFinest()) {
                        logger.finest(this.m_className, "getNext", "WAITING for DATA...");
                    }
                    this.closeFiles();
                    this.m_buffer.wait();
                }
                if (!this.hasNext()) {
                    if (logger.isFinest()) {
                        logger.finest(this.m_className, "getNext", "GOT NO DATA, throwing EX..");
                    }
                    throw new VWException("filenet.sim.animationdp.eventbuf.retrievalError.", "Retrieval error, {0}", this.m_buffer.getStatusMessage());
                }
            }
            byte[] b = null;
            long pos = 0L;
            long pos2 = 0L;
            try {
                this.openFiles();
                this.m_fIndex.seek(this.m_nCurrentElement * 8L);
                pos = this.m_fIndex.readLong();
                pos2 = this.m_fIndex.getFilePointer() == this.m_fIndex.length() ? this.m_fContents.length() : this.m_fIndex.readLong();
            }
            catch (EOFException ex) {
                this.closeFiles();
                Thread.sleep(500L);
            }
            int len = (int)(pos2 - pos);
            if (len <= 0) {
                logger.info(this.m_className, "getNext", "nCurrentElement=" + Long.toString(this.m_nCurrentElement) + ", POS= " + Long.toString(pos) + ", POS2= " + Long.toString(pos2));
                this.closeFiles();
                logger.warning(this.m_className, "getNext", "NO REAL DATA!");
                return null;
            }
            b = new byte[len];
            this.m_fContents.seek(pos);
            this.m_fContents.read(b);
            ++this.m_nCurrentElement;
            AnimationManager[] mgr = AnimationManager.fromBytes(b);
            if (mgr.length > 0 && mgr[0] != null) {
                boolean finished = mgr[0].finished();
                if (finished) {
                    this.m_fContents.close();
                    this.m_fContents = null;
                    this.m_fIndex.close();
                    this.m_fIndex = null;
                    this.m_fTime.close();
                    this.m_fTime = null;
                }
                if (finished || this.m_nCurrentElement % 1000L == 0L) {
                    logger.info(this.m_className, "getNext", "[" + Long.toString(this.m_nCurrentElement) + "]:" + mgr[0].getTimeStamp().toString() + (finished ? " DONE." : " NOT DONE."));
                }
                return mgr[0];
            }
            if (logger.isFinest()) {
                logger.finest(this.m_className, "getNext", "Invalid data.");
            }
            throw new VWException("filenet.sim.animationdp.eventbuf.InvalidData", "Invalid data retrieved.");
        }
        catch (VWException ex) {
            ex.printStackTrace();
            logger.throwing(this.m_className, "getNext", ex);
            throw ex;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.throwing(this.m_className, "getNext", e);
            throw new VWException(e);
        }
    }

    private void openFiles() throws IOException, FileNotFoundException {
        String m_method = "openFiles";
        if (this.m_fTime == null) {
            logger.info(this.m_className, "openFiles", "open for reading: " + this.m_buffer.getTimeFile().getCanonicalPath());
            this.m_fTime = new RandomAccessFile(this.m_buffer.getTimeFile(), "r");
        }
        if (this.m_fIndex == null) {
            logger.info(this.m_className, "openFiles", "open for reading: " + this.m_buffer.getIndexFile().getCanonicalPath());
            this.m_fIndex = new RandomAccessFile(this.m_buffer.getIndexFile(), "r");
        }
        if (this.m_fContents == null) {
            logger.info(this.m_className, "openFiles", "open for reading: " + this.m_buffer.getFile().getCanonicalPath());
            this.m_fContents = new RandomAccessFile(this.m_buffer.getFile(), "r");
        }
    }

    public boolean hasNext() {
        try {
            return this.m_nCurrentElement < this.m_buffer.getSize();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void releaseResources() {
        this.reset();
        this.m_buffer = null;
    }

    private void closeFiles() {
        String m_method = "closeFiles";
        if (this.m_fContents != null) {
            try {
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "closeFiles", "Closing content file.");
                }
                this.m_fContents.close();
                this.m_fContents = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.m_fIndex != null) {
            try {
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "closeFiles", "closing index file.");
                }
                this.m_fIndex.close();
                this.m_fIndex = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.m_fTime != null) {
            try {
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "closeFiles", "closing time file.");
                }
                this.m_fTime.close();
                this.m_fTime = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.m_nCurrentElement = 0L;
        this.closeFiles();
    }

    protected void finalize() {
        this.releaseResources();
    }
}

